;; Tests for i32x4 arithmetic operations on major boundary values and all special values.


(module
  (func (export "i32x4.extmul_low_i16x8_s") (param v128 v128) (result v128) (i32x4.extmul_low_i16x8_s (local.get 0) (local.get 1)))
  (func (export "i32x4.extmul_high_i16x8_s") (param v128 v128) (result v128) (i32x4.extmul_high_i16x8_s (local.get 0) (local.get 1)))
  (func (export "i32x4.extmul_low_i16x8_u") (param v128 v128) (result v128) (i32x4.extmul_low_i16x8_u (local.get 0) (local.get 1)))
  (func (export "i32x4.extmul_high_i16x8_u") (param v128 v128) (result v128) (i32x4.extmul_high_i16x8_u (local.get 0) (local.get 1)))
)


;; i32x4.extmul_low_i16x8_s
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                                  (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                                  (v128.const i32x4 268419072 268419072 268419072 268419072))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                                  (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                                  (v128.const i32x4 268435456 268435456 268435456 268435456))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                                  (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                  (v128.const i32x4 268419072 268419072 268419072 268419072))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                                  (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                  (v128.const i32x4 268435456 268435456 268435456 268435456))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                                  (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                  (v128.const i32x4 268451840 268451840 268451840 268451840))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 32765 32765 32765 32765))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 32766 32766 32766 32766))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 -32768 -32768 -32768 -32768))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 32766 32766 32766 32766))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                                  (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                  (v128.const i32x4 1073676289 1073676289 1073676289 1073676289))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                  (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                  (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                                  (v128.const i32x4 1073709056 1073709056 1073709056 1073709056))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                  (v128.const i32x4 -32767 -32767 -32767 -32767))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extmul_low_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                                  (v128.const i32x4 1 1 1 1))

;; i32x4.extmul_high_i16x8_s
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                                   (v128.const i32x4 268419072 268419072 268419072 268419072))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                                   (v128.const i32x4 268435456 268435456 268435456 268435456))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                   (v128.const i32x4 268419072 268419072 268419072 268419072))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                   (v128.const i32x4 268435456 268435456 268435456 268435456))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                   (v128.const i32x4 268451840 268451840 268451840 268451840))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 32765 32765 32765 32765))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 32766 32766 32766 32766))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 -32768 -32768 -32768 -32768))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 32766 32766 32766 32766))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                   (v128.const i32x4 1073676289 1073676289 1073676289 1073676289))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                                   (v128.const i32x4 1073709056 1073709056 1073709056 1073709056))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                   (v128.const i32x4 -32767 -32767 -32767 -32767))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extmul_high_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                                   (v128.const i32x4 1 1 1 1))

;; i32x4.extmul_low_i16x8_u
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 65535 65535 65535 65535))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 -131071 -131071 -131071 -131071))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                                  (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                                  (v128.const i32x4 268419072 268419072 268419072 268419072))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                                  (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                                  (v128.const i32x4 268435456 268435456 268435456 268435456))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                                  (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                  (v128.const i32x4 -1878999040 -1878999040 -1878999040 -1878999040))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                                  (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                  (v128.const i32x4 -1879048192 -1879048192 -1879048192 -1879048192))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                                  (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                  (v128.const i32x4 -1879097344 -1879097344 -1879097344 -1879097344))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 32765 32765 32765 32765))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 32766 32766 32766 32766))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 -2147385346 -2147385346 -2147385346 -2147385346))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 -2147450881 -2147450881 -2147450881 -2147450881))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 2147450880 2147450880 2147450880 2147450880))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                                  (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                  (v128.const i32x4 1073676289 1073676289 1073676289 1073676289))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                  (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                  (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                                  (v128.const i32x4 1073774592 1073774592 1073774592 1073774592))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                  (v128.const i32x4 65535 65535 65535 65535))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i32x4 -131071 -131071 -131071 -131071))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                  (v128.const i32x4 2147385345 2147385345 2147385345 2147385345))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 2147450880 2147450880 2147450880 2147450880))
(assert_return (invoke "i32x4.extmul_low_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                  (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                                  (v128.const i32x4 -131071 -131071 -131071 -131071))

;; i32x4.extmul_high_i16x8_u
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 65535 65535 65535 65535))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 -131071 -131071 -131071 -131071))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                                   (v128.const i32x4 268419072 268419072 268419072 268419072))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                                   (v128.const i32x4 268435456 268435456 268435456 268435456))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                   (v128.const i32x4 -1878999040 -1878999040 -1878999040 -1878999040))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                   (v128.const i32x4 -1879048192 -1879048192 -1879048192 -1879048192))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                                   (v128.const i32x4 -1879097344 -1879097344 -1879097344 -1879097344))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 32765 32765 32765 32765))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 32766 32766 32766 32766))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 -2147385346 -2147385346 -2147385346 -2147385346))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 -2147450881 -2147450881 -2147450881 -2147450881))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 2147450880 2147450880 2147450880 2147450880))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                   (v128.const i32x4 1073676289 1073676289 1073676289 1073676289))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                                   (v128.const i32x4 1073774592 1073774592 1073774592 1073774592))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (v128.const i32x4 65535 65535 65535 65535))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i32x4 -131071 -131071 -131071 -131071))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                   (v128.const i32x4 2147385345 2147385345 2147385345 2147385345))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 2147450880 2147450880 2147450880 2147450880))
(assert_return (invoke "i32x4.extmul_high_i16x8_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                                   (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                                   (v128.const i32x4 -131071 -131071 -131071 -131071))

;; type check
(assert_invalid (module (func (result v128) (i32x4.extmul_low_i16x8_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i32x4.extmul_high_i16x8_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i32x4.extmul_low_i16x8_u (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i32x4.extmul_high_i16x8_u (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i32x4.extmul_low_i16x8_s-1st-arg-empty (result v128)
      (i32x4.extmul_low_i16x8_s (v128.const i32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.extmul_low_i16x8_s-arg-empty (result v128)
      (i32x4.extmul_low_i16x8_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.extmul_high_i16x8_s-1st-arg-empty (result v128)
      (i32x4.extmul_high_i16x8_s (v128.const i32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.extmul_high_i16x8_s-arg-empty (result v128)
      (i32x4.extmul_high_i16x8_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.extmul_low_i16x8_u-1st-arg-empty (result v128)
      (i32x4.extmul_low_i16x8_u (v128.const i32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.extmul_low_i16x8_u-arg-empty (result v128)
      (i32x4.extmul_low_i16x8_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.extmul_high_i16x8_u-1st-arg-empty (result v128)
      (i32x4.extmul_high_i16x8_u (v128.const i32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.extmul_high_i16x8_u-arg-empty (result v128)
      (i32x4.extmul_high_i16x8_u)
    )
  )
  "type mismatch"
)

