/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QApplication>
#include <QIcon>
#include <QTimer>
#include <QSplashScreen>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes

namespace MsXpS
{

namespace MassXpert
{

class ProgramWindow;

class Application : public QApplication
{
  Q_OBJECT

  public:
  Application(int &argc, char **argv, const QString &application_name);

  ~Application();

  void setProgramWindow(ProgramWindow *program_window_p);
  ProgramWindow *getProgramWindow();

  QString getApplicationName();

  void setDescription(QString &desc);
  QString description();

  QString getUserConfigSettingsDirPath();
  QString getUserConfigSettingsFilePath();

  bool prepareShutdown();

  private:
  QString m_applicationName;
  QString m_organizationName = "MsXpertSuite";
  QString m_description      = QString(
                            "%1: a program to define polymer chemistries and "
                                 "simulate mass spectrometric data")
                            .arg(m_applicationName);
  ProgramWindow *mp_programWindow = nullptr;

  // The splash screen, that vanishes after 2 seconds.
  QSplashScreen *mpa_splash;
  QString m_userConfigSettingsDirPath;
  QString m_userConfigSettingsFilePath;
};


} // namespace MassXpert
} // namespace MsXpS
