/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */

/* -- THIS FILE IS AUTO-GENERATED -- */

#include "mpiimpl.h"

/* -- Begin Profiling Symbol Block for routine MPI_Session_toint */
#if defined(HAVE_PRAGMA_WEAK)
#pragma weak MPI_Session_toint = PMPI_Session_toint
#elif defined(HAVE_PRAGMA_HP_SEC_DEF)
#pragma _HP_SECONDARY_DEF PMPI_Session_toint  MPI_Session_toint
#elif defined(HAVE_PRAGMA_CRI_DUP)
#pragma _CRI duplicate MPI_Session_toint as PMPI_Session_toint
#elif defined(HAVE_WEAK_ATTRIBUTE)
int MPI_Session_toint(MPI_Session session)  __attribute__ ((weak, alias("PMPI_Session_toint")));
#endif
/* -- End Profiling Symbol Block */

/* Define MPICH_MPI_FROM_PMPI if weak symbols are not supported to build
   the MPI routines */
#ifndef MPICH_MPI_FROM_PMPI
#undef MPI_Session_toint
#define MPI_Session_toint PMPI_Session_toint
#endif /* MPICH_MPI_FROM_PMPI */

static int internal_Session_toint(MPI_Session session)
{
    return (int) session;
}

#ifdef ENABLE_QMPI
#ifndef MPICH_MPI_FROM_PMPI
int QMPI_Session_toint(QMPI_Context context, int tool_id, MPI_Session session)
{
    return internal_Session_toint(session);
}
#endif /* MPICH_MPI_FROM_PMPI */
int MPI_Session_toint(MPI_Session session)
{
    QMPI_Context context;
    QMPI_Session_toint_t *fn_ptr;

    context.storage_stack = NULL;

    if (MPIR_QMPI_num_tools == 0)
        return QMPI_Session_toint(context, 0, session);

    fn_ptr = (QMPI_Session_toint_t *) MPIR_QMPI_first_fn_ptrs[MPI_SESSION_TOINT_T];

    return (*fn_ptr) (context, MPIR_QMPI_first_tool_ids[MPI_SESSION_TOINT_T], session);
}
#else /* ENABLE_QMPI */
int MPI_Session_toint(MPI_Session session)
{
    return internal_Session_toint(session);
}

#endif /* ENABLE_QMPI */
